
#Launch the required packages - make sure these are installed to your local version of R
require( geomorph )
require( stringdist )
require( Morpho )
require( rgl )

Landmark.pterygoid <- read.csv("Pterygoid.mean.points.csv", header = T)
Landmark.sliders <- read.csv("Pterygoid.mean.sliders.csv", header = T)

pterygoid.row.names <- Landmark.pterygoid[,1]
Landmark.pterygoid <- as.matrix(Landmark.pterygoid[,2:ncol(Landmark.pterygoid)])
Landmark.pterygoid <- array(Landmark.pterygoid, dim=c(nrow(Landmark.pterygoid), 3 , ncol(Landmark.pterygoid)/3))

dimnames(Landmark.pterygoid)[[ 1 ]] <- pterygoid.row.names
dimnames(Landmark.pterygoid)[[ 2 ]] <- c( "X" , "Y" , "Z" ) 
dimnames(Landmark.pterygoid)[[ 3 ]] <- c("Alectura_NHMUK_S_2010.1.31", "Anas_platyrhynchos_UMZC_225", "Anatalavis_PVA_5922", "Anhima_cornuta_NHMUK_2009.2.2", "Anseranas_semipalmata_NHMUK_1852.7.22.1",
                                        "Biziura_lobata_UMZC_243.A", "Caprimulgus_sp_UMZC_493.CE", "Cereopsis_novaehollandiae_UMZC_242.A", "Chauna_torquata_NHMUK_S_2012.31.1", "Columba_livia_UMZC_721",
                                        "Crypturellus_tataupa_UMMZ_201948", "Dromaius_novaehollandiae_UMZC_362", "Eudromia_elegans_UMZC_404.E", "Eudromias_morinellus_UMZC_351", "Gallinago_gallinago_UMZC_310",
                                        "Gallus_gallus_UMZC_400", "Haematopus_ostralegus_UMZC_350", "Janavis", "Lophophorus_impejanus_UMZC_397.B", "Lymnocryptes_minima_UMZC_311", 
                                        "Megapodius_nicobariensis_UMZC_14-Meg-f-3", "Mergellus_albellus_UMZC_210.B", "Numenius_phaeopus_UMZC_324.C_325", "Numida_meleagris_UMZC_393", "Odontopteryx_NHMUK_PV_44096",
                                        "Pavo_cristatus_UMZC_396.D", "Pipile_pipile_UMZC_391", "Ptilopachus_petrosus_NHMUK_1968.9.2", "Rhea_americana_FMNH_B_339616", "Scolopax_rusticola_UMZC_307", 
                                        "Strix_aluco_Uncat", "Struthio_camelus_DJF_000", "Trogon_collaris_UMZC_438", "Tyto_alba_DJF_19")

##### Perform GPA for a given count of curve semilandmark points ("choose.lm.count") and allow curve semilandmark sliding
##### However, we found that the Procrustes shape was distorted by some curve semilandmarks, especially those relating to the basipterygoid facet and medial crest (discussed in Methods).
##### Therefore, we decided not to allow sliding of all curve semilandmarks (See Methods).
GPA.fit <- gpagen( Landmark.pterygoid , 
                   curves = Landmark.sliders, approxBE = TRUE )

##### Perform GPA for a given count of curve semilandmark points ("choose.lm.count"), but treat all semilandmarks as pseudolandmarks
GPA.fit <- gpagen( Landmark.pterygoid , approxBE = TRUE )

##### Principal Components Analysis
PCA <- plotTangentSpace(GPA.fit$coords, axis1 = 1, axis2 = 2)

